# Import environment set for AVR-GCC.
Import('env_avr')

# Create target environment by cloning AVR environment.
env_target = env_avr.Clone()

# Declare some variables about microcontroller.
# Microcontroller type.
DEVICE = 'atmega328'
# Microcontroller frequency.
CPU_FREQUENCY = '16000000UL' # Hz

# Set environment for an Atmel AVR Atmega 328 microcontroller.
env_target.Append(CCFLAGS = '-mmcu=' + DEVICE)
env_target.Append(LINKFLAGS = '-mmcu=' + DEVICE)
env_target.Append(CPPDEFINES = 'F_CPU=' + CPU_FREQUENCY)

# Export environment set for target.
Export('env_target',  'DEVICE')

